/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.data.ClientScriptData;
import noppes.npcs.controllers.data.ForgeScriptData;
import noppes.npcs.controllers.data.NpcScriptData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.controllers.data.PotionScriptData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.NBTJsonUtil;
import noppes.npcs.util.TempFile;
import noppes.npcs.util.Util;

public class ScriptController {
    public static final Map<Class<?>, String> forgeEventNames = new HashMap();
    public static final Map<Class<?>, String> forgeClientEventNames = new HashMap();
    private static final boolean isClient = Thread.currentThread().getName().toLowerCase().contains("client");
    public static boolean HasStart = false;
    public static ScriptController Instance;
    public boolean isLoad = false;
    public boolean shouldSave = false;
    public long lastLoaded = 0L;
    public long lastPlayerUpdate = 0L;
    public NBTTagCompound compound = new NBTTagCompound();
    public NBTTagCompound constants = new NBTTagCompound();
    public File dir;
    public File clientDir;
    public final Map<String, ScriptEngineFactory> factories = new TreeMap<String, ScriptEngineFactory>();
    public final Map<String, String> languages = new TreeMap<String, String>();
    public final Map<String, Long> sizes = new TreeMap<String, Long>();
    public final Map<String, Long> clientSizes = new TreeMap<String, Long>();
    public final Map<String, String> scripts = new TreeMap<String, String>();
    public final Map<String, String> clients = new TreeMap<String, String>();
    public final Map<String, File> encrypts = new TreeMap<String, File>();
    private final List<String> agreements = new ArrayList<String>();
    private final List<ScriptContainer> errors = new ArrayList<ScriptContainer>();
    private final List<EntityPlayer> opPlayers = new ArrayList<EntityPlayer>();
    private final Map<Integer, List<Object>> elements = new TreeMap<Integer, List<Object>>();
    public ForgeScriptData forgeScripts = new ForgeScriptData();
    public ClientScriptData clientScripts = new ClientScriptData();
    public PlayerScriptData playerScripts = new PlayerScriptData(null);
    public PotionScriptData potionScripts = new PotionScriptData();
    public NpcScriptData npcsScripts = new NpcScriptData();

    public ScriptController() {
        ScriptEngineFactory factory2;
        Class<?> c;
        CustomNpcs.debugData.start(null);
        Instance = this;
        if (!CustomNpcs.NashornArguments.isEmpty()) {
            System.setProperty("nashorn.args", CustomNpcs.NashornArguments);
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        LogWriter.info("Script Engines Available:");
        try {
            c = Class.forName("org.mozilla.javascript.engine.RhinoScriptEngineFactory");
            factory2 = (ScriptEngineFactory)c.newInstance();
            factory2.getScriptEngine();
            manager.registerEngineName("rhino", factory2);
            manager.registerEngineExtension("js", factory2);
            manager.registerEngineMimeType("application/rhino", factory2);
            LogWriter.info("Added script Library: \"rhino\"; type: \"RhinoScriptEngineFactory\"; files index: \".js\"");
            this.languages.put(Util.instance.deleteColor(factory2.getLanguageName()), ".js");
            this.factories.put(factory2.getLanguageName().toLowerCase(), factory2);
        }
        catch (Exception e) {
            LogWriter.info("Rhino JS is missed");
        }
        try {
            c = Class.forName("org.codehaus.groovy.jsr223.GroovyScriptEngineFactory");
            factory2 = (ScriptEngineFactory)c.newInstance();
            factory2.getScriptEngine();
            manager.registerEngineName("groovy", factory2);
            manager.registerEngineExtension("groovy", factory2);
            manager.registerEngineMimeType("application/groovy", factory2);
            LogWriter.info("Added script Library: \"groovy\"; type: \"GroovyScriptEngineFactory\"; files index: \".groovy\"");
            this.languages.put(Util.instance.deleteColor(factory2.getLanguageName()), ".groovy");
            this.factories.put(factory2.getLanguageName().toLowerCase(), factory2);
        }
        catch (Exception e) {
            LogWriter.info("Groovy JS is missed");
        }
        try {
            c = Class.forName("org.jetbrains.kotlin.script.jsr223.KotlinJsr223JvmLocalScriptEngineFactory");
            factory2 = (ScriptEngineFactory)c.newInstance();
            factory2.getScriptEngine();
            manager.registerEngineName("kotlin", factory2);
            manager.registerEngineExtension("kt", factory2);
            manager.registerEngineMimeType("application/kotlin", factory2);
            LogWriter.info("Added script Library: \"kotlin\"; type: \"KotlinJsr223JvmLocalScriptEngineFactory\"; files index: \".kt\"");
            this.languages.put(Util.instance.deleteColor(factory2.getLanguageName()), ".kt");
            this.factories.put(factory2.getLanguageName().toLowerCase(), factory2);
        }
        catch (Exception e) {
            LogWriter.info("Kotlin JS is missed");
        }
        for (ScriptEngineFactory factory2 : manager.getEngineFactories()) {
            try {
                if (factory2.getExtensions().isEmpty()) {
                    LogWriter.debug("Library: \"" + factory2.getLanguageName() + "\"; type: \"" + factory2.getClass().getSimpleName() + "\" Extensions isEmpty ");
                    continue;
                }
                if (!(factory2.getScriptEngine() instanceof Invocable) && !factory2.getLanguageName().equals("lua")) {
                    LogWriter.debug("Library: \"" + factory2.getLanguageName() + "\"; type: \"" + factory2.getClass().getSimpleName() + "\" Engine is not Invocable or not Lua");
                    continue;
                }
                String ext = "." + factory2.getExtensions().get(0).toLowerCase();
                LogWriter.info("Added script Library: \"" + factory2.getLanguageName() + "\"; type: \"" + factory2.getClass().getSimpleName() + "\"; files index: \"" + ext + "\"");
                String name = Util.instance.deleteColor(factory2.getLanguageName());
                if (name.toLowerCase().startsWith("lua")) {
                    name = "LuaJ";
                } else if (name.toLowerCase().startsWith("python") || name.toLowerCase().startsWith("jython")) {
                    name = "Jython";
                } else if (name.toLowerCase().startsWith("ruby")) {
                    name = "JRuby";
                }
                this.languages.put(name, ext);
                this.factories.put(name.toLowerCase(), factory2);
            }
            catch (Throwable t3) {
                LogWriter.error("Error Added Script Library: \"" + factory2.getLanguageName() + "\": " + t3);
            }
        }
        try {
            LogWriter.debug("Try create Nashorn Script Engine");
            Launch.classLoader.addClassLoaderExclusion("jdk.nashorn.");
            Launch.classLoader.addClassLoaderExclusion("jdk.internal.dynalink");
            c = Class.forName("jdk.nashorn.api.scripting.NashornScriptEngineFactory");
            factory2 = (ScriptEngineFactory)c.newInstance();
            factory2.getScriptEngine();
            try {
                Class<?> require = Class.forName("com.coveo.nashorn_modules.Require");
                Method methodEnable = require.getMethod("enable", new Class[0]);
                MethodHandle handle = MethodHandles.lookup().unreflect(methodEnable);
                handle.invoke(factory2, CustomNpcs.getWorldSaveDirectory("scripts/common_js"));
            }
            catch (Throwable t) {
                LogWriter.info("Nashorn Require is missed:");
            }
            String name = Util.instance.deleteColor(factory2.getLanguageName());
            boolean isNotRegister = true;
            if (this.languages.containsKey(name)) {
                String ext = this.languages.get(name);
                ScriptEngineFactory fac = this.factories.get(Util.instance.deleteColor(name).toLowerCase());
                if (fac != null) {
                    String newName = fac.getClass().getSimpleName().replace("EngineFactory", "");
                    this.languages.put(newName, ext);
                    this.factories.put(newName.toLowerCase(), fac);
                    manager.registerEngineName(newName.toLowerCase(), fac);
                    manager.registerEngineMimeType("application/" + newName.toLowerCase(), factory2);
                    isNotRegister = !ext.equals(".js");
                }
            }
            this.languages.put(name, ".js");
            this.factories.put(name.toLowerCase(), factory2);
            manager.registerEngineName(name.toLowerCase(), factory2);
            manager.registerEngineMimeType("application/" + name.toLowerCase(), factory2);
            if (isNotRegister) {
                manager.registerEngineExtension("js", factory2);
            }
        }
        catch (Exception e) {
            LogWriter.info("Nashorn JS is missed");
        }
        if (isClient) {
            this.loadAgreements();
        }
        CustomNpcs.debugData.end(null);
    }

    public File clientScriptsFile() {
        boolean isClient = Thread.currentThread().getName().toLowerCase().contains("client");
        if (isClient && this.clientDir == null) {
            return new File(CustomNpcs.Dir, "client_default/client_scripts.json");
        }
        return new File(this.dir, "client_scripts.json");
    }

    public File constantScriptsFile() {
        return new File(this.dir, "constant_scripts.json");
    }

    private File npcsScriptsFile() {
        return new File(this.dir, "npc_scripts.json");
    }

    private File forgeScriptsFile() {
        return new File(this.dir, "forge_scripts.json");
    }

    private File playerScriptsFile() {
        return new File(this.dir, "player_scripts.json");
    }

    private File potionScriptsFile() {
        return new File(this.dir, "potion_scripts.json");
    }

    private File worldDataFile() {
        return new File(this.dir, "world_data.json");
    }

    public ScriptEngine getEngineByName(String language) {
        ScriptEngineFactory factory = this.factories.get(Util.instance.deleteColor(language).toLowerCase());
        if (factory == null) {
            return null;
        }
        if (factory.getClass().getSimpleName().equals("GraalJSEngineFactory")) {
            return this.getNewGraalEngine();
        }
        return factory.getScriptEngine();
    }

    private ScriptEngine getNewGraalEngine() {
        try {
            Class<?> graal = Class.forName("com.oracle.truffle.js.scriptengine.GraalJSScriptEngine");
            Method create = null;
            for (Method m : graal.getMethods()) {
                if (!m.getName().equals("create") || m.getParameterCount() != 2) continue;
                create = m;
                break;
            }
            if (create == null) {
                return null;
            }
            Class<?> cnt = Class.forName("org.graalvm.polyglot.Context");
            Class<?> hostA = Class.forName("org.graalvm.polyglot.HostAccess");
            Object contextBuilder = cnt.getDeclaredMethod("newBuilder", String[].class).invoke(cnt, new Object[]{new String[]{"js"}});
            if (contextBuilder != null) {
                block21: for (Method m : contextBuilder.getClass().getDeclaredMethods()) {
                    switch (m.getName()) {
                        case "allowExperimentalOptions": 
                        case "allowHostClassLoading": 
                        case "allowNativeAccess": 
                        case "allowIO": 
                        case "allowCreateProcess": {
                            contextBuilder = m.invoke(contextBuilder, true);
                            continue block21;
                        }
                        case "allowHostClassLookup": {
                            contextBuilder = m.invoke(contextBuilder, s -> true);
                            continue block21;
                        }
                        case "allowHostAccess": {
                            if (m.getParameters()[0].getType() == Boolean.class || m.getParameters()[0].getType() == Boolean.TYPE) continue block21;
                            Field f = hostA.getDeclaredField("ALL");
                            Method nb = hostA.getMethod("newBuilder", f.getType());
                            Object hostAccessBuilder = nb.invoke(hostA, f.get(hostA));
                            Method ttm = null;
                            Method b = null;
                            for (Method d : hostAccessBuilder.getClass().getMethods()) {
                                if (d.getName().equals("targetTypeMapping") && d.getParameterCount() == 4) {
                                    ttm = d;
                                }
                                if (!d.getName().equals("build") || d.getParameterCount() != 0) continue;
                                b = d;
                            }
                            if (ttm == null) continue block21;
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Double.class, Byte.class, null, Double::byteValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Double.class, Short.class, null, Double::shortValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Double.class, Integer.class, null, Double::intValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Double.class, Long.class, null, Double::longValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Double.class, Float.class, null, Double::floatValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Double.class, Double.class, null, Double::shortValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Double.class, String.class, null, Object::toString);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Double.class, Boolean.class, null, n -> n != 0.0);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Float.class, Byte.class, null, Float::byteValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Float.class, Short.class, null, Float::shortValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Float.class, Integer.class, null, Float::intValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Float.class, Long.class, null, Float::longValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Float.class, Double.class, null, Float::doubleValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Float.class, String.class, null, Object::toString);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Float.class, Boolean.class, null, n -> n.floatValue() != 0.0f);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Integer.class, Byte.class, null, Integer::byteValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Integer.class, Short.class, null, Integer::shortValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Integer.class, Long.class, null, Integer::longValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Integer.class, Float.class, null, Integer::floatValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Integer.class, Double.class, null, Integer::doubleValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Integer.class, String.class, null, Object::toString);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Integer.class, Boolean.class, null, n -> n != 0);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Long.class, Byte.class, null, Long::byteValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Long.class, Short.class, null, Long::shortValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Long.class, Integer.class, null, Long::intValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Long.class, Float.class, null, Long::floatValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Long.class, Double.class, null, Long::doubleValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Long.class, String.class, null, Object::toString);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Long.class, Boolean.class, null, n -> n != 0L);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Number.class, Byte.class, null, Number::byteValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Number.class, Short.class, null, Number::shortValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Number.class, Integer.class, null, Number::intValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Number.class, Long.class, null, Number::longValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Number.class, Float.class, null, Number::floatValue);
                            hostAccessBuilder = ttm.invoke(hostAccessBuilder, Number.class, Double.class, null, Number::doubleValue);
                            if (b != null) {
                                hostAccessBuilder = b.invoke(hostAccessBuilder, new Object[0]);
                            }
                            contextBuilder = m.invoke(contextBuilder, hostAccessBuilder);
                            continue block21;
                        }
                        case "allowAllAccess": {
                            contextBuilder = m.invoke(contextBuilder, true);
                            continue block21;
                        }
                        case "option": {
                            contextBuilder = m.invoke(contextBuilder, "js.ecmascript-version", "2022");
                            contextBuilder = m.invoke(contextBuilder, "js.nashorn-compat", "true");
                            continue block21;
                        }
                    }
                }
                return (ScriptEngine)create.invoke(graal, null, contextBuilder);
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        return null;
    }

    private Map<String, Long> getScripts(String language, boolean isClient) {
        TreeMap<String, Long> map = new TreeMap<String, Long>();
        String ext = this.languages.get(Util.instance.deleteColor(language));
        if (ext == null) {
            return map;
        }
        for (String script : (isClient ? this.clients : this.scripts).keySet()) {
            if (!script.endsWith(ext)) continue;
            map.put(script, (isClient ? this.clientSizes : this.sizes).get(script));
        }
        if (!isClient) {
            ext = ext.replace(".", ".p");
            for (String script : this.encrypts.keySet()) {
                if (!script.endsWith(ext)) continue;
                map.put(script, this.sizes.get(script));
            }
        }
        return map;
    }

    public void load() {
        CustomNpcs.debugData.start(null);
        ScriptController sData = Instance;
        sData.loadCategories();
        sData.loadStoredData();
        sData.loadPlayerScripts();
        sData.loadForgeScripts();
        sData.loadNPCsScripts();
        sData.loadPotionScripts();
        sData.loadConstantData();
        if (isClient) {
            sData.loadClientScripts();
        }
        this.checkExampleModules();
        HasStart = true;
        CustomNpcs.debugData.end(null);
    }

    public void loadCategories() {
        this.dir = new File(CustomNpcs.getWorldSaveDirectory(), "scripts");
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            return;
        }
        this.clientDir = new File(this.dir, "client");
        if (!this.clientDir.exists() && !this.clientDir.mkdirs()) {
            return;
        }
        if (!this.worldDataFile().exists()) {
            this.shouldSave = true;
        }
        WorldWrapper.clearTempdata();
        this.scripts.clear();
        this.encrypts.clear();
        this.sizes.clear();
        for (String key : this.clients.keySet()) {
            CommonProxy.downloadableFiles.remove(key);
        }
        this.clients.clear();
        this.clientSizes.clear();
        for (String language : this.languages.keySet()) {
            String ext = this.languages.get(Util.instance.deleteColor(language));
            File scriptDir = new File(this.dir, language.toLowerCase());
            if (!scriptDir.exists() && !scriptDir.mkdir()) continue;
            this.loadDir(scriptDir, "", ext, false, false);
            this.loadDir(scriptDir, "", ext.replace(".", ".p"), true, false);
            scriptDir = new File(this.clientDir, language.toLowerCase());
            if (!scriptDir.exists() && !scriptDir.mkdir()) continue;
            this.loadDir(scriptDir, "", ext, false, true);
        }
        this.lastLoaded = System.currentTimeMillis();
        this.isLoad = true;
    }

    public boolean loadClientScripts() {
        this.clientScripts.clear();
        File file = this.clientScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.clientScripts.readFromNBT(NBTJsonUtil.LoadFile(file));
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    public boolean loadConstantData() {
        this.constants = new NBTTagCompound();
        File file = this.constantScriptsFile();
        boolean isLoad = true;
        try {
            if (file.exists()) {
                this.constants = NBTJsonUtil.LoadFile(file);
                boolean needResave = false;
                NBTBase tag = this.constants.func_74781_a("Constants");
                if (!(tag instanceof NBTTagCompound)) {
                    needResave = true;
                    this.constants.func_74782_a("Constants", (NBTBase)new NBTTagCompound());
                }
                NBTTagCompound nbtC = new NBTTagCompound();
                NBTTagCompound cons = this.constants.func_74775_l("Constants");
                HashSet keys = new HashSet(cons.func_150296_c());
                for (String key : keys) {
                    if (!cons.func_74764_b(key) || (tag = cons.func_74781_a(key)) instanceof NBTTagCompound && this.factories.containsKey(key)) continue;
                    nbtC.func_74782_a(key, tag);
                    cons.func_82580_o(key);
                    needResave = true;
                }
                if (needResave) {
                    cons.func_74782_a("ecmascript", (NBTBase)nbtC);
                    this.constants.func_74782_a("Constants", (NBTBase)cons);
                }
                if (!((tag = this.constants.func_74781_a("Functions")) instanceof NBTTagCompound)) {
                    if (tag instanceof NBTTagList && ((NBTTagList)tag).func_150303_d() == 8) {
                        NBTTagList list = ((NBTTagList)tag).func_74737_b();
                        this.constants.func_74782_a("Functions", (NBTBase)new NBTTagCompound());
                        this.constants.func_74775_l("Functions").func_74782_a("ecmascript", (NBTBase)list);
                    } else {
                        this.constants.func_74782_a("Functions", (NBTBase)new NBTTagCompound());
                    }
                    needResave = true;
                }
                for (String key : this.factories.keySet()) {
                    tag = this.constants.func_74775_l("Constants").func_74781_a(key);
                    if (!(tag instanceof NBTTagCompound)) {
                        needResave = true;
                        this.constants.func_74775_l("Constants").func_74782_a(key, (NBTBase)new NBTTagCompound());
                    }
                    if ((tag = this.constants.func_74775_l("Functions").func_74781_a(key)) instanceof NBTTagList) continue;
                    needResave = true;
                    this.constants.func_74775_l("Functions").func_74782_a(key, (NBTBase)new NBTTagList());
                }
                if (needResave) {
                    try {
                        Util.instance.saveFile(file, this.constants.func_74737_b());
                        TextComponentString message = new TextComponentString("Constants have been rewritten for all scripts to ");
                        message.func_150256_b().func_150238_a(TextFormatting.GRAY);
                        NoppesUtilServer.NotifyOPs(message.func_150258_a(file.getName()), true);
                    }
                    catch (Exception e) {
                        LogWriter.except(e);
                    }
                }
            } else {
                for (String key : this.factories.keySet()) {
                    if (!this.constants.func_74775_l("Constants").func_150297_b(key, 10)) {
                        this.constants.func_74775_l("Constants").func_74782_a(key, (NBTBase)new NBTTagCompound());
                    }
                    if (this.constants.func_74775_l("Functions").func_150297_b(key, 10)) continue;
                    this.constants.func_74775_l("Functions").func_74782_a(key, (NBTBase)new NBTTagCompound());
                }
                NBTTagCompound nbtC = ScriptController.getNbtDefaultConstants();
                NBTTagList list = new NBTTagList();
                list.func_74742_a((NBTBase)new NBTTagString("function getField(key,object) { try { var f = dump(object).getField(key); if (f) { return f.getValue(); } } catch (error) { log('Error: \"'+key+'\" is not a Field or not found in \"'+object.getClass().getName()+'\"');} return null; }"));
                list.func_74742_a((NBTBase)new NBTTagString("function setField(value,object,key) { try { var f = dump(object).getField(key); if (f) { return f.setValue(value); } } catch (error) { log('Error: \"'+key+'\" is not a Field or not found, or not type mismatch in \"'+object.getClass().getName()+'\". Error: ' + error); } return false; }"));
                list.func_74742_a((NBTBase)new NBTTagString("function invoke(value,object,key) { try { var m = dump(object).getMethod(key); if (m) { var jo = Java.type('java.lang.Object[]'); if (value!=jo) { try { if (value.length>=0) { var v = new jo(value.length); for (var i=0; i<value.length; i++) { v[i] = value[i]; } return m.invoke(v); } } catch (err) { } var v = new jo(1); v[0] = value; return m.invoke(v); } else { return m.invoke(value); } } } catch (error) { log('Error: \"'+key+'\" is not a Method or not found, or not type mismatch in \"'+object.getClass().getName()+'\"'); } return null; }"));
                list.func_74742_a((NBTBase)new NBTTagString("function getCustomFunction(name, ev) {var fhm;try {var actor=\"Any\";if (ev) {if (ev.player) { actor = \"Player\"; }else if (ev.npc) { actor = \"NPC\"; }else if (ev.block) { actor = \"Block\"; }};fhm = api.getIWorld(0).getTempdata().get(\"functions\");if (fhm instanceof JHMap && fhm.containsKey(name)) {return fhm.get(name)};if (name!=\"loadFile\") {var dir = existsDir(api.getWorldDir().toPath().resolve(\"data\").resolve(\"functions\"));gFunc(\"loadFile\",ev)(dir.resolve(name+\".json\"), \"fhm\");if (fhm instanceof JHMap && fhm.containsKey(name)) {return fhm.get(name)}}} catch (error) {if (fhm && fhm instanceof JHMap) {gFunc(\"errorMes\",ev)(actor, error, \"Name: \u00a7f\"+name, ev);}};return eval(\"function fnull(a,b,c,d,e,f,g,h,i,k,l,m,n,o,p,r,s,t,q,v) {return;}\");}"));
                this.constants.func_74782_a("Constants", (NBTBase)new NBTTagCompound());
                this.constants.func_74782_a("Functions", (NBTBase)new NBTTagCompound());
                this.constants.func_74775_l("Constants").func_74782_a("ecmascript", (NBTBase)nbtC);
                this.constants.func_74775_l("Functions").func_74782_a("ecmascript", (NBTBase)list);
                try {
                    Util.instance.saveFile(file, this.constants.func_74737_b());
                    isLoad = false;
                }
                catch (Exception e) {
                    LogWriter.except(e);
                }
            }
            ScriptContainer.reloadConstants();
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return isLoad;
    }

    private static NBTTagCompound getNbtDefaultConstants() {
        NBTTagCompound nbtC = new NBTTagCompound();
        nbtC.func_74768_a("value", 0);
        nbtC.func_74778_a("Lists", "Java.type(\"com.google.common.collect.Lists\")");
        nbtC.func_74778_a("List", "Java.type(\"java.util.ArrayList\")");
        nbtC.func_74778_a("Collections", "Java.type(\"java.util.Collections\")");
        nbtC.func_74778_a("UUID", "Java.type(\"java.util.UUID\")");
        nbtC.func_74778_a("HashMap", "Java.type(\"java.util.HashMap\")");
        nbtC.func_74778_a("HashSet", "Java.type(\"java.util.HashSet\")");
        nbtC.func_74778_a("Files", "Java.type(\"java.nio.file.Files\")");
        nbtC.func_74778_a("File", "Java.type(\"java.io.File\")");
        nbtC.func_74778_a("FileOutputStream", "Java.type(\"java.io.FileOutputStream\")");
        nbtC.func_74778_a("FileInputStream", "Java.type(\"java.io.FileInputStream\")");
        nbtC.func_74778_a("String", "Java.type(\"java.lang.String\")");
        nbtC.func_74778_a("StringArray", "Java.type(\"java.lang.String[]\")");
        nbtC.func_74778_a("sData", "Java.type(\"noppes.npcs.api.NpcAPI\").Instance().getIWorld(0).getStoreddata()");
        nbtC.func_74778_a("tData", "Java.type(\"noppes.npcs.api.NpcAPI\").Instance().getIWorld(0).getTempdata()");
        nbtC.func_74778_a("JsonToNBT", "Java.type(\"net.minecraft.nbt.JsonToNBT\")");
        nbtC.func_74778_a("NBTTagByte", "Java.type(\"net.minecraft.nbt.NBTTagByte\")");
        nbtC.func_74778_a("NBTTagInt", "Java.type(\"net.minecraft.nbt.NBTTagInt\")");
        nbtC.func_74778_a("NBTTagFloat", "Java.type(\"net.minecraft.nbt.NBTTagFloat\")");
        nbtC.func_74778_a("NBTTagDouble", "Java.type(\"net.minecraft.nbt.NBTTagDouble\")");
        nbtC.func_74778_a("NBTTagByteArray", "Java.type(\"net.minecraft.nbt.NBTTagByteArray\")");
        nbtC.func_74778_a("NBTTagString", "Java.type(\"net.minecraft.nbt.NBTTagString\")");
        nbtC.func_74778_a("NBTTagList", "Java.type(\"net.minecraft.nbt.NBTTagList\")");
        nbtC.func_74778_a("NBTTagCompound", "Java.type(\"net.minecraft.nbt.NBTTagCompound\")");
        nbtC.func_74778_a("NBTTagIntArray", "Java.type(\"net.minecraft.nbt.NBTTagIntArray\")");
        nbtC.func_74778_a("CompressedStreamTools", "Java.type(\"net.minecraft.nbt.CompressedStreamTools\")");
        nbtC.func_74778_a("EnumParticleTypes", "Java.type(\"net.minecraft.util.EnumParticleTypes\")");
        nbtC.func_74778_a("Serializer", "Java.type(\"net.minecraft.util.text.ITextComponent.Serializer\")");
        nbtC.func_74778_a("TextComponentTranslation", "Java.type(\"net.minecraft.util.text.TextComponentTranslation\")");
        nbtC.func_74778_a("TextComponentString", "Java.type(\"net.minecraft.util.text.TextComponentString\")");
        nbtC.func_74778_a("TextComponentSelector", "Java.type(\"net.minecraft.util.text.TextComponentSelector\")");
        nbtC.func_74778_a("Style", "Java.type(\"net.minecraft.util.text.Style\")");
        nbtC.func_74778_a("ClickEvent", "Java.type(\"net.minecraft.util.text.event.ClickEvent\")");
        nbtC.func_74778_a("HoverEvent", "Java.type(\"net.minecraft.util.text.event.HoverEvent\")");
        nbtC.func_74778_a("ClickEventAction", "Java.type(\"net.minecraft.util.text.event.ClickEvent.Action\")");
        nbtC.func_74778_a("HoverEventAction", "Java.type(\"net.minecraft.util.text.event.HoverEvent.Action\")");
        nbtC.func_74778_a("BlockPos", "Java.type(\"net.minecraft.util.math.BlockPos\")");
        nbtC.func_74778_a("Item", "Java.type(\"net.minecraft.item.Item\")");
        nbtC.func_74778_a("ItemStack", "Java.type(\"net.minecraft.item.ItemStack\")");
        nbtC.func_74778_a("ResourceLocation", "Java.type(\"net.minecraft.util.ResourceLocation\")");
        nbtC.func_74778_a("AttributeModifier", "Java.type(\"net.minecraft.entity.ai.attributes.AttributeModifier\")");
        nbtC.func_74778_a("RangedAttribute", "Java.type(\"net.minecraft.entity.ai.attributes.RangedAttribute\")");
        nbtC.func_74778_a("SharedMonsterAttributes", "Java.type(\"net.minecraft.entity.SharedMonsterAttributes\")");
        nbtC.func_74778_a("InventoryBasic", "Java.type(\"net.minecraft.inventory.InventoryBasic\")");
        nbtC.func_74778_a("PotionEffect", "Java.type(\"net.minecraft.potion.PotionEffect\")");
        nbtC.func_74778_a("ForgeRegistries", "Java.type(\"net.minecraftforge.fml.common.registry.ForgeRegistries\")");
        nbtC.func_74778_a("ScriptController", "Java.type(\"noppes.npcs.controllers.ScriptController\").Instance");
        nbtC.func_74778_a("ScriptContainer", "Java.type(\"noppes.npcs.controllers.ScriptContainer\")");
        nbtC.func_74778_a("TransportController", "Java.type(\"noppes.npcs.controllers.TransportController\")");
        return nbtC;
    }

    private void checkExampleModules() {
        for (String fName : this.languages.keySet()) {
            File file;
            String factoryName = Util.instance.deleteColor(fName).toLowerCase();
            String code = "";
            switch (factoryName) {
                case "ecmascript": 
                case "rhino": {
                    code = "var hi = \"Hello\";\nfunction init(ev) {\n\tvar id = 0;\n\tev.API.getIWorld(0).broadcast(hi  + \" world ID:\" + id);\n}\n";
                    break;
                }
                case "graaljs": {
                    code = "var hi = \"Hello\";\nfunction init(ev) {\n\tlet id = 0;\n\tev.API.getIWorld(\"overworld\").broadcast(hi + \" world ID: \" + id);\n}\n";
                    break;
                }
                case "groovy": {
                    code = "binding.setVariable('hi', 'Hello')\nvoid init(def ev) {\n\tdef id = 0\n\tev.API.getIWorld(0).broadcast(hi + \" world ID:\" + id)\n}\n";
                    break;
                }
                case "jruby": {
                    code = "hi = \"Hello\"\ndef init(ev)\n\tid = 0\n\tev.API.getIWorld(0).broadcast(hi + \" world ID:\" + id.to_s)\nend\n";
                    break;
                }
                case "jython": {
                    code = "hi = \"Hello\"\ndef init(ev):\n\tid = 0\n\tev.API.getIWorld(0).broadcast(hi + \" world ID:\" + str(id))\n";
                    break;
                }
                case "luaj": {
                    code = "local hi = \"Hello\"\nfunction init(ev)\n\tlocal id = 0\n\tev.API:getIWorld(0):broadcast(hi .. \" world ID:\" .. tostring(id))\nend\n";
                }
            }
            if (code.isEmpty()) continue;
            String ext = Util.instance.deleteColor(this.languages.get(fName)).toLowerCase();
            if (ext.equals(".js")) {
                switch (factoryName) {
                    case "rhino": {
                        ext = "_rh.js";
                        break;
                    }
                    case "graaljs": {
                        ext = "_gr.js";
                    }
                }
            }
            if ((file = new File(this.dir, factoryName + "/example" + ext)).exists()) continue;
            Util.instance.saveFile(file, code);
        }
    }

    public boolean loadNPCsScripts() {
        this.npcsScripts.clear();
        File file = this.npcsScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.npcsScripts.readFromNBT(NBTJsonUtil.LoadFile(file));
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    public boolean loadForgeScripts() {
        this.forgeScripts.clear();
        File file = this.forgeScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.forgeScripts.readFromNBT(NBTJsonUtil.LoadFile(file));
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    public void loadItemTextures() {
        ItemScripted.Resources.clear();
        File file = new File(this.dir, "item_models.dat");
        if (!file.exists()) {
            return;
        }
        try {
            NBTTagCompound compound = NBTJsonUtil.LoadFile(file);
            for (NBTBase nbt : compound.func_150295_c("Models", 10)) {
                ItemScripted.Resources.put(((NBTTagCompound)nbt).func_74762_e("meta"), ((NBTTagCompound)nbt).func_74779_i("model"));
            }
            CustomNpcs.proxy.reloadItemTextures();
        }
        catch (Exception e) {
            LogWriter.error("File: \"" + file + "\" error:", e);
        }
    }

    public boolean loadPlayerScripts() {
        this.playerScripts.clear();
        File file = this.playerScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.playerScripts.readFromNBT(NBTJsonUtil.LoadFile(file));
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    public boolean loadPotionScripts() {
        this.potionScripts.clear();
        File file = this.potionScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.potionScripts.readFromNBT(NBTJsonUtil.LoadFile(file));
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    public boolean loadStoredData() {
        this.compound = new NBTTagCompound();
        File file = this.worldDataFile();
        boolean isLoad = true;
        try {
            if (file.exists()) {
                this.compound = NBTJsonUtil.LoadFile(file);
                WrapperNpcAPI.resetScriptControllerData(this.compound);
                this.shouldSave = false;
            } else {
                isLoad = false;
            }
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return isLoad;
    }

    public void loadDir(File dir, String name, String ext, boolean encrypt, boolean isClient) {
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            String filename = name + file.getName().toLowerCase();
            if (file.isDirectory()) {
                this.loadDir(file, filename + "/", ext, encrypt, isClient);
                continue;
            }
            if (!filename.endsWith(ext)) continue;
            if (encrypt) {
                if (!isClient) {
                    this.encrypts.put(filename, file);
                }
            } else {
                String code = Util.instance.loadFile(file);
                if (isClient) {
                    this.clients.put(filename, code);
                } else {
                    this.scripts.put(filename, code);
                }
            }
            if (isClient) {
                this.clientSizes.put(filename, file.length());
                continue;
            }
            this.sizes.put(filename, file.length());
        }
    }

    public NBTTagList nbtLanguages(boolean isClient) {
        NBTTagList list = new NBTTagList();
        for (String language : this.languages.keySet()) {
            String ext = this.languages.get(Util.instance.deleteColor(language));
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList scripts = new NBTTagList();
            Map<String, Long> map = this.getScripts(language, isClient);
            long[] cs = new long[map.size()];
            int i = 0;
            for (String script : map.keySet()) {
                scripts.func_74742_a((NBTBase)new NBTTagString(script));
                cs[i++] = map.get(script) * (long)(!script.endsWith(ext) ? -1 : 1);
            }
            compound.func_74782_a("Scripts", (NBTBase)scripts);
            compound.func_74778_a("Language", language);
            compound.func_74778_a("FileSfx", ext);
            compound.func_74782_a("sizes", (NBTBase)new NBTTagLongArray(cs));
            list.func_74742_a((NBTBase)compound);
        }
        return list;
    }

    public void saveItemTextures() {
        File file = new File(this.dir, "item_models.dat");
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return;
                }
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        if (!file.exists()) {
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (int meta : ItemScripted.Resources.keySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("meta", meta);
            nbt.func_74778_a("model", ItemScripted.Resources.get(meta));
            list.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("Models", (NBTBase)list);
        Util.instance.saveFile(file, compound);
    }

    @SubscribeEvent
    public void saveWorld(WorldEvent.Save event) {
        if (!this.shouldSave || event.getWorld().field_72995_K || event.getWorld() != Objects.requireNonNull(event.getWorld().func_73046_m()).field_71305_c[0]) {
            return;
        }
        try {
            Util.instance.saveFile(this.worldDataFile(), this.compound.func_74737_b());
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        try {
            Util.instance.saveFile(this.constantScriptsFile(), this.constants.func_74737_b());
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        this.shouldSave = false;
    }

    public void sendClientTo(EntityPlayerMP player) {
        NBTTagCompound compound = new NBTTagCompound();
        this.clientScripts.writeToNBT(compound);
        Server.sendData(player, EnumPacketClient.SCRIPT_CLIENT, compound);
        NBTTagList list = new NBTTagList();
        for (String key : this.clients.keySet()) {
            TempFile file;
            if (!CommonProxy.downloadableFiles.containsKey(key)) {
                CommonProxy.downloadableFiles.put(key, new TempFile(key, 0, 1, this.clientSizes.get(key)));
            }
            if (!(file = CommonProxy.downloadableFiles.get(key)).isLoad()) {
                file.size = -1L;
                file.saveType = 1;
                file.reset(this.clients.get(key));
            }
            list.func_74742_a((NBTBase)file.getTitle());
        }
        compound = new NBTTagCompound();
        compound.func_74782_a("FileList", (NBTBase)list);
        Server.sendData(player, EnumPacketClient.SEND_FILE_LIST, compound);
    }

    public void setClientScripts(NBTTagCompound compound) {
        this.clientScripts.readFromNBT(compound);
        File file = this.clientScriptsFile();
        try {
            compound.func_82580_o("WorldName");
            Util.instance.saveFile(file, compound);
            this.clientScripts.lastInited = -1L;
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void setNPCsScripts(NBTTagCompound compound) {
        this.npcsScripts.readFromNBT(compound);
        File file = this.npcsScriptsFile();
        try {
            Util.instance.saveFile(file, compound);
            this.npcsScripts.lastInited = -1L;
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void setForgeScripts(NBTTagCompound compound) {
        this.forgeScripts.readFromNBT(compound);
        File file = this.forgeScriptsFile();
        try {
            Util.instance.saveFile(file, compound);
            this.forgeScripts.lastInited = -1L;
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void setPlayerScripts(NBTTagCompound compound) {
        this.playerScripts.readFromNBT(compound);
        if (CustomNpcs.Server != null) {
            for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
                PlayerData data = PlayerData.get((EntityPlayer)player);
                if (data == null) continue;
                data.scriptData.readFromNBT(compound);
            }
        }
        try {
            Util.instance.saveFile(this.playerScriptsFile(), compound);
            this.lastPlayerUpdate = System.currentTimeMillis();
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void setPotionScripts(NBTTagCompound compound) {
        this.potionScripts.readFromNBT(compound);
        File file = this.potionScriptsFile();
        try {
            Util.instance.saveFile(file, compound);
            this.potionScripts.lastInited = -1L;
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    private void loadAgreements() {
        this.agreements.clear();
        LogWriter.error("Load player script agreements");
        File file = new File(CustomNpcs.Dir, "agreements.dat");
        boolean err = false;
        if (file.exists()) {
            try {
                NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
                for (int i = 0; i < compound.func_150295_c("Agreements", 8).func_74745_c(); ++i) {
                    this.agreements.add(compound.func_150295_c("Agreements", 8).func_150307_f(i));
                }
            }
            catch (Exception e) {
                err = true;
                LogWriter.error("Error load agreements:", e);
            }
        }
        if (!file.exists() || err) {
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)new NBTTagCompound(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            }
            catch (Exception e) {
                LogWriter.error("Error default save agreements:", e);
            }
        }
        LogWriter.debug("Found " + this.agreements.size() + " agreements");
    }

    private void saveAgreements() {
        LogWriter.error("Save player script agreements");
        File file = new File(CustomNpcs.Dir, "agreements.dat");
        try {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (String agreement : this.agreements) {
                list.func_74742_a((NBTBase)new NBTTagString(agreement));
            }
            compound.func_74782_a("Agreements", (NBTBase)list);
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            LogWriter.error("Error save agreements:", e);
        }
        LogWriter.debug("Save " + this.agreements.size() + " agreements");
    }

    public void setAgreement(String agreementName, boolean isAgree) {
        boolean bo = isAgree ? this.agreements.add(agreementName) : this.agreements.remove(agreementName);
        if (bo) {
            this.saveAgreements();
        }
    }

    public boolean notAgreement(String agreementName) {
        return !this.agreements.contains(agreementName);
    }

    public void checkAgreements(List<String> checkList) {
        if (checkList == null) {
            return;
        }
        boolean bo = false;
        ArrayList<String> worldAgreements = new ArrayList<String>(this.agreements);
        for (String key : worldAgreements) {
            if (key.split(";").length > 2 || checkList.contains(key)) continue;
            if (this.agreements.remove(key)) {
                bo = true;
            }
            checkList.remove(key);
        }
        if (bo) {
            this.saveAgreements();
        }
    }

    public void tryAddErrored(ScriptContainer scriptContainer) {
        if (this.errors.contains(scriptContainer)) {
            return;
        }
        this.errors.add(scriptContainer);
        if (CustomNpcs.Server == null) {
            return;
        }
        PlayerList pList = CustomNpcs.Server.func_184103_al();
        TextComponentTranslation message = new TextComponentTranslation("command.script.logs.view", new Object[0]);
        for (EntityPlayer entityplayer : pList.func_181057_v()) {
            if (this.opPlayers.contains(entityplayer) || !entityplayer.func_174792_t_() || !pList.func_152596_g(entityplayer.func_146103_bH())) continue;
            entityplayer.func_145747_a((ITextComponent)message);
            this.opPlayers.add(entityplayer);
        }
    }

    public void tryRemoveErrored(ScriptContainer scriptContainer) {
        this.errors.remove(scriptContainer);
    }

    public List<ScriptContainer> getErrored() {
        ArrayList<ScriptContainer> list = new ArrayList<ScriptContainer>();
        for (ScriptContainer container : new ArrayList<ScriptContainer>(this.errors)) {
            if (container == null || !container.hasHandler() || container.console.isEmpty()) continue;
            list.add(container);
        }
        this.errors.clear();
        this.errors.addAll(list);
        return this.errors;
    }

    public void tryAdd(int type, Object obj) {
        CustomNPCsScheduler.runTack(() -> {
            if (!this.elements.containsKey(type)) {
                this.elements.put(type, new ArrayList());
            }
            if (this.elements.get(type).contains(obj)) {
                return;
            }
            this.elements.get(type).add(obj);
        });
    }

    public ITextComponent getElements(int type) {
        if (!this.elements.containsKey(type)) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        ArrayList objs = new ArrayList(this.elements.get(type));
        for (Object obj : objs) {
            String key;
            TileNpcEntity tile;
            BlockPos pos = null;
            int dimId = 0;
            if (type == 0 && obj instanceof TileScripted) {
                tile = (TileScripted)obj;
                pos = tile.func_174877_v();
                if (tile.func_145831_w() == null || tile.func_145831_w().func_175625_s(pos) != tile) {
                    pos = null;
                    this.elements.get(type).remove(obj);
                } else {
                    dimId = tile.func_145831_w().field_73011_w.getDimension();
                }
            } else if (type == 1 && obj instanceof TileScriptedDoor) {
                tile = (TileScriptedDoor)obj;
                pos = tile.func_174877_v();
                if (tile.func_145831_w() == null || tile.func_145831_w().func_175625_s(pos) != tile) {
                    pos = null;
                    this.elements.get(type).remove(obj);
                } else {
                    dimId = tile.func_145831_w().field_73011_w.getDimension();
                }
            } else if (type == 2 && obj instanceof EntityNPCInterface) {
                EntityNPCInterface npc = (EntityNPCInterface)((Object)obj);
                pos = npc.func_180425_c();
                if (npc.field_70170_p == null || npc.field_70170_p.func_73045_a(npc.func_145782_y()) != npc) {
                    pos = null;
                    this.elements.get(type).remove(obj);
                } else {
                    dimId = npc.field_70170_p.field_73011_w.getDimension();
                }
            }
            if (pos == null || list.contains(key = ":[DimID: " + dimId + "; X:" + pos.func_177958_n() + ", Y:" + pos.func_177956_o() + ", Z:" + pos.func_177952_p() + "]")) continue;
            list.add(key);
        }
        StringBuilder positions = new StringBuilder();
        int i = 0;
        for (String pos : list) {
            positions.append(i + 1).append(pos);
            if (i < list.size() - 1) {
                positions.append(", ");
            }
            ++i;
        }
        return new TextComponentString(positions.toString());
    }
}

